// H. Moessenboeck: Sprechen Sie Java? -- Kapitel 10, Aufgabe 3
// "Datumsberechnung"

class Date {
	int day;
	int month;
	int year;
}

public class A3 {
	static int[] daysBefore = {0, 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
	
	// Read a date; assume that the data is correct
	static Date readDate() {
		Date d = new Date();
		d.day = In.readInt();
		d.month = In.readInt();
		d.year = In.readInt();
		if (In.done()) return d; else return null;
	}
	
	// Print a date
	static void printDate(Date d) {
		Out.print(d.day + "." + d.month + "." + d.year);
	}
	
	// Return the number of days since 1.1.0000 (assuming Gregorian calendar)
	static int daysSince0(Date d) {
		int days = 365 * d.year + daysBefore[d.month] + d.day - 1;
		if (d.month > 2 && d.year % 4 == 0 && (d.year % 100 != 0 || d.year % 400 == 0)) days++;
		days += (d.year-1) / 4 - (d.year-1) / 100 + (d.year-1) / 400;
		return days;
	}
	
	// Return the number of days between two dates
	static int dayDiff(Date d1, Date d2) {
		int days1 = daysSince0(d1);
		int days2 = daysSince0(d2);
		return Math.abs(days1 - days2);
	}
	
	public static void main(String args[]) {
		In.open("input.txt");
		Date d1 = readDate();
		while (d1 != null) {
			Date d2 = readDate();
			printDate(d1); Out.print(", "); printDate(d2);
			Out.println(": Differenz in Tagen = " + dayDiff(d1, d2));
			d1 = readDate();
		}
		In.close();
	}
}

/*
Sample input:
12 3 2001 3 4 2001
14 7 1789 12 3 2001
14 7 1789 4 7 1776
12 3 2001 12 3 2001
1 1 0000 30 8 2001
*/